/*******************************************************
Filename		:  	DW_station_download_custom.sql
Release 		:  	STORET c2.0, C2.0.1
SIR			:  	1370, 1559
Description		:  	Creates a report in the form of a text file that contains the 
				columns the user has requested.
Author			:  	Joseph Wilson
Date			: 	November 12, 2002; December 5, 2002
				May 11, 2003 -- declared linesize in file creation call of 4000 -JW
				June 23, 2003 -- made proc compatible with report element groupings and IDs -JW
				July 7, 2003 -- added new v2.0 data elements and capitalized columns for consistancy -JW
				July 8, 2003 -- combined with result report elements table, updated table alias, added defaults -JW
                        	July 29, 2003 SIR 1507 - Updated to show records of all location point types (not only Point of Record). -C Tsang
				Auguest 22, 2003 -- changed report file extension to txt -JW
				Sept 30, 2003 -- added BLOB URLs to report -JW
				07/14/2004 - updated reports to use datum code rather than full desc -JW
				07/30/2004 - increased var sizes for SQL and report generation -JW
				08/04/2004 - increased size of report output vars -JW
Comments		:  	Uses the table APP_COLUMN_NAME to create the column titles. Dynamic SQL
				is used so only the requested columns and corresponding tables are included
				in the query.
**********************************************************/

CREATE OR REPLACE PROCEDURE DW_STATION_download_custom
(v_FromStmt			IN	VARCHAR2,
v_WhereStmt			IN	VARCHAR2,
v_Columns			IN	owa_util.ident_arr,
filename                	IN	varchar2,
out_file			OUT	varchar2
) AS
--The out_file variable, the output of this routine, contains the entire URL of 
--the file created herein.
-- File handler while creating a file using utl_file package.
my_out_file		UTL_FILE.FILE_TYPE;
--
--Name of downloadable file that will be created on the server.  This 
--file name will be generated based on the current date and time.
out_file_name		VARCHAR2(30);
iodir         		VARCHAR2(100);
download_path 		VARCHAR2(100);
lv_rows       		NUMBER;

v_pk_isn		NUMBER(12);
v_Dummy			INTEGER;
v_CursorID		INTEGER;
v_SQLStmt		VARCHAR2(32000);
v_SelectStmt		VARCHAR2(32000);
v_ReturnRow   		VARCHAR2(32000);
v_Print_Name		VARCHAR2(40);
v_Print_Names_List	VARCHAR2(32000);
v_FromStmtNew 		VARCHAR2(32000);
v_WhereStmtNew 		VARCHAR2(32000);
v_CurrentColumn		VARCHAR2(200);

--flags used to ensure a table is not included twice in the FROM clause
f_LU_STATN_TYPES 	BOOLEAN := FALSE;
f_LU_GEO_STATE 		BOOLEAN := FALSE;

v_stn_report_number	number;

CURSOR c_ReportColumn IS
	SELECT print_name,col_name
		FROM APP_COLUMN_NAME
		WHERE stn_report_number = v_stn_report_number
		ORDER BY stn_col_order;
BEGIN
rollback;

v_SelectStmt := 'SELECT DISTINCT(FA.pk_isn),';
v_FromStmtNew := v_FromStmt;
v_WhereStmtNew := v_WhereStmt;
--include appropriate tables based on columns selected
	FOR i IN 1 .. v_Columns.LAST LOOP
		v_stn_report_number := TO_NUMBER(v_Columns(i));
		--OPEN c_ReportColumn;
		FOR ReportColumn in c_ReportColumn LOOP
			--v_SelectStmt := v_SelectStmt ||ReportColumn.col_name||'||''~''||';
			--SELECT print_name INTO v_print_name
			--	FROM APP_COLUMN_NAME2
			--	WHERE col_name = v_Columns(i);
			v_CurrentColumn := ReportColumn.col_name;
			v_print_names_list := v_print_names_list||ReportColumn.print_name||'~';
    
		IF ReportColumn.col_name = 'PRIMARY_TYPE' OR ReportColumn.col_name = 'SECONDARY_TYPE' THEN
			IF f_LU_STATN_TYPES = FALSE THEN
				v_FromStmtNew := v_FromStmtNew||',DI_STATN_TYPES st';
				v_WhereStmtNew := v_WhereStmtNew||' AND fk_statn_types = st.pk_isn (+)';
				f_LU_STATN_TYPES := TRUE;
			END IF;
		END IF;
		IF ReportColumn.col_name = 'HD.ID_CODE' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM hd';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_mad_hdatum = hd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'SHD.ID_CODE' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM shd';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_std_hdatum = shd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'GEOPOSITIONING_METHOD' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HMETHOD hm';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_mad_hmethod = hm.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'ORGANIZATION_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_ORG og';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_org = og.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'ELEVATION_DATUM' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_VDATUM vd';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_mad_vdatum = vd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'ELEVATION_METHOD' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_VMETHOD vm';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_mad_vmethod = vm.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'STATE_NAME' OR ReportColumn.col_name = 'COUNTRY_NAME' THEN
			IF f_LU_GEO_STATE = FALSE THEN
				v_FromStmtNew := v_FromStmtNew||',DI_GEO_STATE gs';
				v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_state = gs.pk_isn (+)';
				f_LU_GEO_STATE := TRUE;
			END IF;
		END IF;
		IF ReportColumn.col_name = 'COUNTY_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_GEO_COUNTY gc';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_county = gc.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_db_cat = ca.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'PRIMARY_ESTUARY' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_ESTRY_PRIMARY ep';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_estry_primary = ep.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name = 'SECONDARY_ESTUARY' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_ESTRY_SECONDARY es';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_estry_secondary = es.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'FA.BLOB_ID' THEN
			v_CurrentColumn := 'DECODE(FA.BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.BLOB_ID)''';
		END IF;
		--CLOSE c_ReportColumn;
		v_SelectStmt := v_SelectStmt ||v_CurrentColumn||'||''~''||';
		END LOOP;
	END LOOP;  

v_SelectStmt := RTRIM(v_SelectStmt,'||''~''||');
v_print_names_list := RTRIM(v_print_names_list,'||''~''||');

--v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD'' ORDER BY organization_id, station_id';
v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;

--htp.print(v_sqlstmt||'<br>'||v_print_names_list);

v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_pk_isn, 12);
DBMS_SQL.DEFINE_COLUMN(v_CursorID, 2, v_ReturnRow, 32000);

v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

--checking to see if a filename is passed
if (filename <> 'NONE') then
	out_file_name := filename;
else   
	-- Generating a unique name for creating a file on the server.
	out_file_name := TO_CHAR(SYSDATE,'YYYYMMDD_HH24MISS');  
	out_file_name := 'SDS'||out_file_name||'.txt' ;    
end if;
--
-- File handler used by utl_file package.  
--
iodir := DW_GLOB_VAR.LV_IODIR;
download_path := DW_GLOB_VAR.LV_DOWNLOAD_PATH;

my_out_file := UTL_FILE.FOPEN(iodir,out_file_name,'W',30000);         
--
-- out_file is an out parameter.  It holds URL of the downloadable file that 
-- will be created by this procedure.
out_file:=download_path||out_file_name;

UTL_FILE.PUT_LINE(my_out_file,v_print_names_list);

LOOP
	IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
		EXIT;
	END IF;
	DBMS_SQL.COLUMN_VALUE(v_CursorID, 2, v_ReturnRow);
	UTL_FILE.PUT_LINE(my_out_file,v_ReturnRow);
END LOOP;

DBMS_SQL.CLOSE_CURSOR(v_CursorID);
UTL_FILE.FCLOSE(my_out_file); 

EXCEPTION
  WHEN UTL_FILE.INVALID_PATH THEN DBMS_OUTPUT.PUT_LINE ('INVALID PATH');
  commit;
  WHEN UTL_FILE.INVALID_MODE THEN DBMS_OUTPUT.PUT_LINE ('INVALID MODE');
  commit;
  WHEN UTL_FILE.INVALID_FILEHANDLE THEN 
  commit;
    DBMS_OUTPUT.PUT_LINE ('INVALID FILEHANDLE');
  WHEN UTL_FILE.INVALID_OPERATION THEN 
    DBMS_OUTPUT.PUT_LINE ('INVALID OPERATION');
  commit;
  WHEN UTL_FILE.READ_ERROR THEN DBMS_OUTPUT.PUT_LINE ('BAD READ');
  commit;
  WHEN UTL_FILE.WRITE_ERROR THEN DBMS_OUTPUT.PUT_LINE ('BAD WRITE');
  commit;
  WHEN UTL_FILE.INTERNAL_ERROR THEN DBMS_OUTPUT.PUT_LINE ('INTERNAL');
  commit;
END; 
/                                                                                                   
show errors